

use [redacted due to personal information], clear

destring ResultsID, force replace
 
merge m:m ResultsID using  [redacted due to personal information]

 bysort ResultsID: gen index=_n 

 keep if index == 1

 drop _merge
 
 merge m:m TECID using [redacted due to personal information]
 
 drop index
 
  bysort ResultsID: gen index=_n 
  
  tabulate index

 keep if index == 1

 drop _merge
  

merge 1:m ResultsID using  [redacted due to personal information], force

drop _merge 

merge 1:m ResultsID using [redacted due to personal information], force

drop _merge 

merge 1:m ResultsID using [redacted due to personal information], force

drop _merge

merge 1:1 ResultsID using [redacted due to personal information], force

drop _merge 

merge 1:1 ResultsID using [redacted due to personal information], force 

drop _merge 

merge 1:1 ResultsID using [redacted due to personal information]

drop _merge 

drop index

drop if  TECID  == ""

* destring TECID, force replace 

bysort TECID: gen index=_n 

drop if index==2 
  
drop DateCompleted


merge m:m  TECID using [redacted due to personal information], force

drop _merge 

merge 1:1 TECID using [redacted due to personal information], force 

drop _merge

merge 1:1 TECID using [redacted due to personal information], force

drop _merge 

merge 1:1 TECID using [redacted due to personal information], force

drop _merge 

merge 1:1 TECID using [redacted due to personal information], force

drop _merge 

merge 1:1 TECID using [redacted due to personal information], force


* rename covid variables 

* The main symptoms of COVID-19 (coronavirus) are 1) a high temperature or 2) a new, continuous cough. Have you displayed either of these symptoms over the last two weeks?

* ( 1=yes; 2=no)

rename COVBL18 cov_sympt_2weeks

* In the last four weeks, have you been admitted to hospital for COVID-19 (coronavirus)?

* ( 1=yes; 2=no)

rename COVBL29 hospitalization_covid


* In the last four weeks, have you been admitted to hospital for a mental health condition?

* ( 1=yes; 2=no)


rename COVBL30 hospitalization_menth

* The next questions are about how you've been feeling over the last two weeks. Over the last 2 weeks, how often have you felt little interest or pleasure in doing things?

* (1 to 4 from not at all; several days, more than half the days, nearly every day)

rename COVBL48  lack_interest_C

* Over the last 2 weeks, how often have you felt down, depressed, or hopeless?

* (1 to 4 from not at all; several days, more than half the days, nearly every day)

rename COVBL49 depress_C

* Over the last 2 weeks, how often have you had trouble falling or staying asleep, or sleeping too much?

rename COVBL50 sleep_prob_C

* Over the last 2 weeks, how often have you felt tired or had little energy?

rename COVBL51 tired_energ_C

* Over the last 2 weeks, how often have you been bothered by a poor appetite or overeating?

 rename COVBL52 eating_prob_C

* Over the last 2 weeks, how often have you been bothered about feeling bad about yourself or that you are a failure or have let yourself or your family down?

rename COVBL53 failuare_C

* Over the last 2 weeks, how often have you had trouble concentrating on things, such as reading the newspaper or watching television?

rename COVBL54 concentrat_C

* Over the last 2 weeks, how often have you been bothered by moving or speaking so slowly that other people could have noticed?  Or the opposite — being so fidgety or restless that you have been moving around a lot more than usual?

rename COVBL55 movement_C

* Over the last 2 weeks, how often have you had thoughts that you would be better off dead or of hurting yourself in some way?

rename COVBL56 self_hurt_C

* Over the last 2 weeks, how often have you been bothered by feeling nervous, anxious or on edge?

rename COVBL57 anxious_C

* Over the last 2 weeks, how often have you been bothered by not being able to stop or control worrying?

rename COVBL58 uncontrolledworry_C

* Over the last 2 weeks, how often have you been bothered by worrying too much about different things?

rename COVBL59 worry_worry_C

* Over the last 2 weeks, how often have you had trouble relaxing?

rename COVBL60 relaxing_C

* Over the last 2 weeks, how often have you been bothered by being so restless that it is hard to sit still?

rename COVBL61 restless_C

* Over the last 2 weeks, how often have you been bothered about becoming easily annoyed or irritable?

rename COVBL62 easily_annoyed_C

* Over the last 2 weeks, how often have you been bothered about feeling afraid as if something awful might happen?

rename COVBL63 aftraid_C

* calculate total score for IADL difficulty 

replace MEALDIFF = "" if MEALDIFF == "NULL"

replace  HOUSEDIFF = "" if  HOUSEDIFF == "NULL"

replace FINANCEDIFF = "" if FINANCEDIFF == "NULL"

replace MEDDIFF = "" if MEDDIFF == "NULL"

replace PHONEDIFF = "" if PHONEDIFF == "NULL"

replace SHOPDIFF = "" if SHOPDIFF == "NULL"

replace TRANSDIFF = "" if TRANSDIFF == "NULL"

destring MEALDIFF HOUSEDIFF FINANCEDIFF MEDDIFF PHONEDIFF SHOPDIFF TRANSDIFF, replace 

egen iadldifficulty_T2 = rowtotal (MEALDIFF HOUSEDIFF FINANCEDIFF MEDDIFF PHONEDIFF SHOPDIFF TRANSDIFF)

replace iadldifficulty_T2 = .  if MEALHELP  == .

order iadldifficulty_T2, after (TRANSDIFF )


* 1.1 In your life, have you suffered from a period of mental distress that prevented you from doing your usual activities?

rename MH1 mental_health_episode_T2

* 1.2 In your life, did you seek or receive help from a professional (medical doctor, psychologist, social worker, counsellor, nurse, clergy, or other helping professional) for mental distress, psychological problems or unusual experiences?

rename MH2 Seek_mental_help_T2

* 1.3 Have you been diagnosed with one or more of the following mental health problems by a professional, even if you don’t have it currently? (check all that apply):

* 01 = Depression 02 = Mania, hypomania, bipolar or manic-depression 03 = Anxiety, nerves or generalized anxiety disorder 04 = Social anxiety or social phobia 05 = Agoraphobia 06 = Panic attacks 07 = Obsessive compulsive disorder (OCD) 00 = None of the above NA = Do not know DA = Prefer not to answer

rename MH3_DEP lifetime_dep_T2

rename MH3_MANIA lifetime_mania_T2

rename MH3_ANXIETY lifetime_anxiety_T2

rename MH3_SOCIAL lifetime_social_anx_T2

rename MH3_AGRO lifetime_agoraf_T2

rename MH3_PANIC lifetime_panic_T2

rename MH3_OCD lifetime_OCD_T2

rename MH4_ANOREXIA lifetime_anorexia_T2

rename MH4_BULIMIA lifetime_bulimia_T2

rename MH4_OVEREATING lifetime_overeating_T2

rename MH4_SCHIZL lifetime_schiz_T2

rename MH4_PSYCHOSIS lifetime_psych_T2

rename MH4_PERSONALITY lifetime_pers_t2

rename MH4_AUTISM lifetime_autism_t2

rename MH4_ADHD lifetime_adhd_t2

* PHQ-9 depression over the past two weeks questionnaire 

* 2.1 Over the last 2 weeks, how often have you felt little interest or pleasure in doing things?

destring MH6 MH7 MH8 MH9 MH10 MH11 MH12 MH13 MH14, replace
 
replace MH7 = "" if MH7 == "NULL"

destring MH7, replace

recode MH6 (99=.)

recode MH7 (99=.)

recode MH8 (99=.)

recode MH9 (99=.)

recode MH10 (99=.)

recode MH11 (99=.)

recode MH12 (99=.)

recode MH13 (99=.)

recode MH14 (99=.)

* 2.1 Over the last 2 weeks, how often have you felt little interest or pleasure in doing things?

rename MH6 PHQ_pleasure_T2

* 2.2 Over the last 2 weeks, how often have you felt down, depressed, or hopeless?

rename MH7 PHQ_depr_T2

* 2.3 Over the last 2 weeks, how often have you had trouble falling or staying asleep, or sleeping too much?

rename MH8 PHQ_sleep_T2

* 2.4 Over the last 2 weeks, how often have felt tired or had little energy?

rename MH9 PHQ_tired_T2

* 2.5 Over the last 2 weeks, how often have you been bothered by a poor appetite or overeating?

rename MH10 PHQ_appetite_t2

* 2.6 Over the last 2 weeks, how often have you been bothered about feeling bad about yourself or that you are a failure or have let yourself or your family down?

rename MH11 PHQ_failure_T2

* 2.7 Over the last 2 weeks, how often have you had trouble concentrating on things, such as reading the newspaper or watching television?

rename MH12 PHQ_concentr_T2

* 2.8 Over the last 2 weeks, how often have you been bothered by moving or speaking so slowly that other people could have noticed?  Or the opposite — being so fidgety or restless that you have been moving around a lot more than usual?

rename MH13 PHQ_restless_T2

* 2.9 Over the last 2 weeks, how often have you had thoughts that you would be better off dead or of hurting yourself in some way?

rename MH14 PHQ_selfharm_T2


* List missing in PHQ_1 to impute the mean

list ResultsID if PHQ_pleasure_T2 == . & PHQ_depr_T2 != . & PHQ_sleep_T2 !=. & PHQ_tired_T2 !=. & PHQ_appetite_t2 != . ///
&  PHQ_failure_T2 !=. & PHQ_concentr_T2 !=. &  PHQ_restless_T2 !=. & PHQ_selfharm_T2 !=. 

summarize PHQ_pleasure_T2

* Impute the mean 

 recode PHQ_pleasure_T2 (. = 1.25) if PHQ_pleasure_T2 == . & PHQ_depr_T2 != . & PHQ_sleep_T2 !=. & PHQ_tired_T2 !=. & PHQ_appetite_t2 != . ///
&  PHQ_failure_T2 !=. & PHQ_concentr_T2 !=. &  PHQ_restless_T2 !=. & PHQ_selfharm_T2 !=. 
 

* List missing in PHQ_2 to impute the mean

list ResultsID if PHQ_pleasure_T2 != . & PHQ_depr_T2 == . & PHQ_sleep_T2 !=. & PHQ_tired_T2 !=. & PHQ_appetite_t2 != . ///
&  PHQ_failure_T2 !=. & PHQ_concentr_T2 !=. &  PHQ_restless_T2 !=. & PHQ_selfharm_T2 !=. 

summarize PHQ_depr_T2

* Impute the mean

 recode PHQ_depr_T2 (. = 1.24) if PHQ_pleasure_T2 != . & PHQ_depr_T2 == . & PHQ_sleep_T2 !=. & PHQ_tired_T2 !=. & PHQ_appetite_t2 != . ///
&  PHQ_failure_T2 !=. & PHQ_concentr_T2 !=. &  PHQ_restless_T2 !=. & PHQ_selfharm_T2 !=. 
 
 
 * List missing in PHQ_3 to impute the mean

list ResultsID if PHQ_pleasure_T2 != . & PHQ_depr_T2 != . & PHQ_sleep_T2 ==. & PHQ_tired_T2 !=. & PHQ_appetite_t2 != . ///
&  PHQ_failure_T2 !=. & PHQ_concentr_T2 !=. &  PHQ_restless_T2 !=. & PHQ_selfharm_T2 !=. 

summarize PHQ_sleep_T2

* Impute the mean 

 recode PHQ_sleep_T2 (. = 1.68) if PHQ_pleasure_T2 != . & PHQ_depr_T2 != . & PHQ_sleep_T2 ==. & PHQ_tired_T2 !=. & PHQ_appetite_t2 != . ///
&  PHQ_failure_T2 !=. & PHQ_concentr_T2 !=. &  PHQ_restless_T2 !=. & PHQ_selfharm_T2 !=. 
 
  
 * List missing in PHQ_4 to impute the mean

list ResultsID if PHQ_pleasure_T2 != . & PHQ_depr_T2 != . & PHQ_sleep_T2 !=. & PHQ_tired_T2 ==. & PHQ_appetite_t2 != . ///
&  PHQ_failure_T2 !=. & PHQ_concentr_T2 !=. &  PHQ_restless_T2 !=. & PHQ_selfharm_T2 !=. 


  * List missing in PHQ_5 to impute the mean

list ResultsID if PHQ_pleasure_T2 != . & PHQ_depr_T2 != . & PHQ_sleep_T2 !=. & PHQ_tired_T2 !=. & PHQ_appetite_t2 == . ///
&  PHQ_failure_T2 !=. & PHQ_concentr_T2 !=. &  PHQ_restless_T2 !=. & PHQ_selfharm_T2 !=. 

summarize PHQ_appetite_t2

* Impute the mean 

 recode PHQ_appetite_t2 (. = 1.21) if PHQ_pleasure_T2 != . & PHQ_depr_T2 != . & PHQ_sleep_T2 !=. & PHQ_tired_T2 !=. & PHQ_appetite_t2 == . ///
&  PHQ_failure_T2 !=. & PHQ_concentr_T2 !=. &  PHQ_restless_T2 !=. & PHQ_selfharm_T2 !=. 
 
 
   * List missing in PHQ_6 to impute the mean

list ResultsID if PHQ_pleasure_T2 != . & PHQ_depr_T2 != . & PHQ_sleep_T2 !=. & PHQ_tired_T2 !=. & PHQ_appetite_t2 != . ///
&  PHQ_failure_T2 ==. & PHQ_concentr_T2 !=. &  PHQ_restless_T2 !=. & PHQ_selfharm_T2 !=. 

summarize PHQ_failure_T2

* Impute the mean 

 recode PHQ_failure_T2 (. = 1.17) if PHQ_pleasure_T2 != . & PHQ_depr_T2 != . & PHQ_sleep_T2 !=. & PHQ_tired_T2 !=. & PHQ_appetite_t2 != . ///
&  PHQ_failure_T2 ==. & PHQ_concentr_T2 !=. &  PHQ_restless_T2 !=. & PHQ_selfharm_T2 !=. 
  
 
* List missing in PHQ_7 to impute the mean

list ResultsID if PHQ_pleasure_T2 != . & PHQ_depr_T2 != . & PHQ_sleep_T2 !=. & PHQ_tired_T2 !=. & PHQ_appetite_t2 != . ///
&  PHQ_failure_T2 !=. & PHQ_concentr_T2 ==. &  PHQ_restless_T2 !=. & PHQ_selfharm_T2 !=. 


    * List missing in PHQ_8 to impute the mean

list ResultsID if PHQ_pleasure_T2 != . & PHQ_depr_T2 != . & PHQ_sleep_T2 !=. & PHQ_tired_T2 !=. & PHQ_appetite_t2 != . ///
&  PHQ_failure_T2 !=. & PHQ_concentr_T2 !=. &  PHQ_restless_T2 ==. & PHQ_selfharm_T2 !=. 


    * List missing in PHQ_9 to impute the mean

list ResultsID if PHQ_pleasure_T2 != . & PHQ_depr_T2 != . & PHQ_sleep_T2 !=. & PHQ_tired_T2 !=. & PHQ_appetite_t2 != . ///
&  PHQ_failure_T2 !=. & PHQ_concentr_T2 !=. &  PHQ_restless_T2 !=. & PHQ_selfharm_T2 ==. 

summarize PHQ_selfharm_T2

* Impute the mean 

 recode PHQ_selfharm_T2 (. = 1.04) if PHQ_pleasure_T2 != . & PHQ_depr_T2 != . & PHQ_sleep_T2 !=. & PHQ_tired_T2 !=. & PHQ_appetite_t2 != . ///
&  PHQ_failure_T2 !=. & PHQ_concentr_T2 !=. &  PHQ_restless_T2 !=. & PHQ_selfharm_T2 ==. 
  
 egen phq_total_T2 = rowtotal  (PHQ_pleasure_T2 PHQ_depr_T2 PHQ_sleep_T2 PHQ_tired_T2 PHQ_appetite_t2 PHQ_failure_T2 PHQ_concentr_T2 PHQ_restless_T2 PHQ_selfharm_T2)
 
 replace phq_total_T2 = . if  PHQ_pleasure_T2 == . 
 
 order phq_total_T2, after (PHQ_selfharm_T2) 
 
 * 2.10 Have you ever had a time in your life when you felt sad, blue, or depressed for two weeks or more in a row? 
 
 rename MH15 lifetime_sad_T2
 
 
 * 2.11 Have you ever had a time in your life lasting two weeks or more when you lost interest in most things like hobbies, work, or activities that usually give you pleasure? 
 
 rename MH16  lifetime_nointerest_T2
 
 * GAD-7 
 
 rename MH47 GAD_1_T2
 
 rename MH48 GAD_2_T2
 
 rename  MH49 GAD_3_T2
 
 rename MH50 GAD_4_T2
 
 rename MH51 GAD_5_T2
 
 rename MH52 GAD_6_T2
 
 destring GAD_6_T2, force replace
 
 rename MH53 GAD_7_T2
 
 
 
recode GAD_1_T2 (99=.)
 
recode GAD_2_T2 (99=.)
 
recode GAD_3_T2 (99=.)
 
recode GAD_4_T2 (99=.)
 
recode GAD_5_T2 (99=.)
 
recode GAD_6_T2 (99=.)

recode GAD_7_T2 (99=.)
 
 * ITEM 1 

list ResultsID if GAD_1_T2 == . & GAD_2_T2 != . & GAD_3_T2 !=. & GAD_4_T2 !=. & GAD_5_T2 != . ///
&  GAD_6_T2 !=. & GAD_7_T2 !=.

* 1 case missing in item 1 (3897806)

summarize GAD_1_T2

recode GAD_1_T2 (. = 1.30) if GAD_1_T2 == . & GAD_2_T2 != . & GAD_3_T2 !=. & GAD_4_T2 !=. & GAD_5_T2 != . ///
&  GAD_6_T2 !=. & GAD_7_T2 !=.

* ITEM 2

list ResultsID if GAD_2_T2 == . & GAD_1_T2 != . & GAD_3_T2 !=. & GAD_4_T2 !=. & GAD_5_T2 != . ///
&  GAD_6_T2 !=. & GAD_7_T2 !=.

summarize GAD_2_T2

recode GAD_2_T2 (. = 1.21) if GAD_1_T2 != . & GAD_2_T2 == . & GAD_3_T2 !=. & GAD_4_T2 !=. & GAD_5_T2 != . ///
&  GAD_6_T2 !=. & GAD_7_T2 !=.


* ITEM 3

list ResultsID if GAD_3_T2 == . & GAD_2_T2 != . & GAD_1_T2 !=. & GAD_4_T2 !=. & GAD_5_T2 != . ///
&  GAD_6_T2 !=. & GAD_7_T2 !=.

* 3 cases missing in item 3 ( 1256157, 7645899,   9175843)

summarize GAD_3_T2

recode GAD_3_T2 (. = 1.28) if GAD_3_T2 == . & GAD_2_T2 != . & GAD_1_T2 !=. & GAD_4_T2 !=. & GAD_5_T2 != . ///
&  GAD_6_T2 !=. & GAD_7_T2 !=.


* ITEM 4 

list ResultsID if GAD_4_T2 == . & GAD_2_T2 != . & GAD_3_T2 !=. & GAD_1_T2 !=. & GAD_5_T2 != . ///
&  GAD_6_T2 !=. & GAD_7_T2 !=.

* one case missing in item 4 (6443403)

summarize GAD_4_T2

recode GAD_4_T2 (. = 1.27) if GAD_4_T2 == . & GAD_2_T2 != . & GAD_3_T2 !=. & GAD_1_T2 !=. & GAD_5_T2 != . ///
&  GAD_6_T2 !=. & GAD_7_T2 !=.

* ITEM 5 

list ResultsID if GAD_5_T2 == . & GAD_2_T2 != . & GAD_3_T2 !=. & GAD_4_T2 !=. & GAD_1_T2 != . ///
&  GAD_6_T2 !=. & GAD_7_T2 !=.

* no missing 


* ITEM 6 

list ResultsID if GAD_6_T2 == . & GAD_2_T2 != . & GAD_3_T2 !=. & GAD_4_T2 !=. & GAD_5_T2 != . ///
&  GAD_1_T2 !=. & GAD_7_T2 !=.

* ITEM 7
      
list ResultsID if GAD_7_T2 == . & GAD_2_T2 != . & GAD_3_T2 !=. & GAD_4_T2 !=. & GAD_5_T2 != . ///
&  GAD_6_T2 !=. & GAD_1_T2 !=.

* 4 cases missing in item 7 (2444286, 2931508, 5451932, 7022277)

summarize GAD_7_T2 

recode GAD_7_T2 (. = 1.15) if GAD_7_T2 == . & GAD_2_T2 != . & GAD_3_T2 !=. & GAD_4_T2 !=. & GAD_5_T2 != . ///
&  GAD_6_T2 !=. & GAD_1_T2 !=.

egen gad_total_T2 = rowtotal (GAD_1_T2 GAD_2_T2 GAD_3_T2 GAD_4_T2 GAD_5_T2 GAD_6_T2 GAD_7_T2)
 
replace gad_total_T2 = . if GAD_1_T2 == .  
 

destring HEIGHT weight20, replace

* add cognition in 2015 /change scores 

gen datecompl = dofc(DateCompleted)

format datecompl %td

gen monthsubmitted = month(datecompl)

keep if AARClosses_2019 != . 

keep if Age_T1 != . 

* 830 study sample 

* use a computer 

* 0= never; 1= once; 2= twice or more ). 

tabulate comp_times_19

* how many total hours they engage in the selected activity in a typical week (1 = less than 1 hour; 2 = 1-2 ½ hours; 3 = 3-4 ½ hours; 4 = 5-6 ½ hours; 5 = 7-8 ½ hours; 6 = 9 or more hours). 

tabulate comp_long_19

* gains

generate comp_freq_19 = 0 if comp_long_19 == "0"

replace comp_freq_19 = 1 if comp_long_19 == "1"

replace comp_freq_19 = 3 if comp_long_19 == "3"

replace comp_freq_19 = 5 if comp_long_19 == "5"

replace comp_freq_19 = 7 if comp_long_19 == "7"

replace comp_freq_19 = 9 if comp_long_19 == "9"


 regress comp_freq_19  AARCgains_2019, beta
 
 sem (AARCgains_2019 -> comp_freq_19), nocapslatent standardized
  
 pcorr comp_freq_19 AARCgains_2019  Age_T1 Gender_T1 EDUCATION_T1 
 
 sem (AARCgains_2019 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1 -> comp_freq_19  ), nocapslatent standardized  
  
 * explore whether age moderates the associations 
 
  regress comp_freq_19  c.AARCgains_2019##c.Age_T1
  
  regress comp_freq_19  c.AARCgains_2019##c.Age_T1  Gender_T1 EDUCATION_T1 Employment_T1
  
  
* losses 
 
 regress comp_freq_19  AARClosses_2019, beta
 
 sem (AARClosses_2019 -> comp_freq_19), nocapslatent standardized
  
 sem (AARClosses_2019 Age_T1 Gender_T1 EDUCATION_T1 -> comp_freq_19  ), nocapslatent standardized
  
sem (AARClosses_2019 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1 -> comp_freq_19  ), nocapslatent standardized

 * explore whether age moderates the associations 
 
  regress comp_freq_19  c.AARClosses_2019##c.Age_T1
  
  regress comp_freq_19  c.AARClosses_2019##c.Age_T1  Gender_T1 EDUCATION_T1 Employment_T1
  
  
* try gains and losses in the same regression 

 regress comp_freq_19  AARCgains_2019 AARClosses_2019, beta
 
 sem (AARClosses_2019 -> comp_freq_19), nocapslatent standardized
  
 pcorr comp_freq_19 AARCgains_2019 AARClosses_2019  Age_T1 Gender_T1 EDUCATION_T1 
 
 sem (AARCgains_2019 AARClosses_2019 Age_T1 Gender_T1 EDUCATION_T1 -> comp_freq_19  ), nocapslatent standardized
  
sem (AARCgains_2019 AARClosses_2019 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1 -> comp_freq_19  ), nocapslatent standardized
    
 * ATOA
 
 regress comp_freq_19  ATOA_F_19, beta
 
 sem (ATOA_F_19 -> comp_freq_19), nocapslatent standardized
  
 pcorr comp_freq_19 ATOA_F_19  Age_T1 Gender_T1 EDUCATION_T1 
 
sem (ATOA_F_19 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1 -> comp_freq_19  ), nocapslatent standardized
    
* explore whether age moderates the associations 
 
regress comp_freq_19  c.ATOA_F_19##c.Age_T1

regress comp_freq_19  c.ATOA_F_19##c.Age_T1  Gender_T1 EDUCATION_T1 Employment_T1
  
tabulate comp_times_20

tabulate comp_long_20


generate comp_freq_20 = 0 if comp_long_20 == "0"

replace comp_freq_20 = 1 if comp_long_20 == "1"

replace comp_freq_20 = 3 if comp_long_20 == "3"

replace comp_freq_20 = 5 if comp_long_20 == "5"

replace comp_freq_20 = 7 if comp_long_20 == "7"

replace comp_freq_20 = 9 if comp_long_20 == "9"
 
* COGNTIIVE TRAINING ITEMS 
 
* How frequently do you engage in…? 1. word puzzles, e.g. crosswords

* 1 - more than once a day; 2 - once a day; 3 - once a week; 4 - once a month; 5 - occasionally; 6 - never
 
codebook wordpuz_19 wordpuz_20

* How frequently do you engage in…? 2. number puzzles, e.g. sudoku

* 1 - more than once a day; 2 - once a day; 3 - once a week; 4 - once a month; 5 - occasionally; 6 - never
 
 codebook numbpuz_19 numbpuz_20 
 
* How frequently do you engage in…? 3. 'brain training' games played on a computer
 
* 1 - more than once a day; 2 - once a day; 3 - once a week; 4 - once a month; 5 - occasionally; 6 - never
 
codebook braincomp_19 braincomp_20
  
* How frequently do you engage in…? 4. 'brain training' games not played on a computer
 
* 1 - more than once a day; 2 - once a day; 3 - once a week; 4 - once a month; 5 - occasionally; 6 - never
 
 codebook braing_19

* cross-sectional associations for remaining risk factors. 

* Do you regularly use any of the following technologies? yes no answers
* TECHTYPE1 - Desktop computer
* TECHTYPE2 - Laptop
* TECHTYPE3 - Tablet
* TECHTYPE4 - Smartphone (iPhone)
* TECHTYPE5 - Smartphone (Android software)
* TECHTYPE6 - Kindle
* TECHTYPE7 - Wearable fitness monitors (e.g. Fitbit)
* TECHTYPE8 - Personal music players (e.g. iPod 
 
codebook techtype1_19
 
codebook techtype2_19
 
 codebook techtype3_19
 
 codebook techtype4_19
 
 codebook techtype5_19
 
 codebook techtype6_19
 
 codebook techtype7_19

 codebook techtype8_19
 
egen numtechused_19 = rowtotal (techtype1_19 techtype2_19 techtype3_19 techtype4_19 techtype5_19 techtype6_19 techtype7_19 techtype8_19 )
 
tabulate numtechused_19

* 2020 

egen numtechused_20 = rowtotal (techtype1_20 techtype2_20 techtype3_20 techtype4_20 techtype5_20 techtype6_20 techtype7_20 techtype8_20 )
 
tabulate numtechused_20
 
*  How often do you use… these technologies

* 0 - never; 1 - occasionally; 2 - once a month; 3 - once a week; 4 - once a day ; 5 - more than once a day
 
 codebook techreg_19
 
 generate freq_tech_19 = 0 if techreg_19 == "0"
 
 replace freq_tech_19 = 1 if techreg_19 == "1" 
 
 replace freq_tech_19 = 2 if techreg_19 == "2"  
 
 replace freq_tech_19 = 3 if techreg_19 == "3" 
 
 replace freq_tech_19 = 4 if techreg_19 == "4" 
 
 replace freq_tech_19 = 5 if techreg_19 == "5" 
 
 replace freq_tech_19 = . if techreg_19 == "" 
 
 tabulate freq_tech_19

drop if freq_tech_19 == .
 
 * 2020 
 
 generate freq_tech_20 = 0 if techreg_20 == "0"
 
 replace freq_tech_20 = 1 if techreg_20 == "1" 
 
 replace freq_tech_20 = 2 if techreg_20 == "2"  
 
 replace freq_tech_20 = 3 if techreg_20 == "3" 
 
 replace freq_tech_20 = 4 if techreg_20 == "4" 
 
 replace freq_tech_20 = 5 if techreg_20 == "5" 
 
 replace freq_tech_20 = . if techreg_20 == "" 
 
 tabulate freq_tech_20 
 
 
 *  How often do you use…? the internet 

codebook interntreg_19

generate freq_internet_19 = 0 if interntreg_19 == "0"

replace freq_internet_19 = 1 if interntreg_19 == "1"

replace freq_internet_19 = 2 if interntreg_19 == "2"

replace freq_internet_19 = 3 if interntreg_19 == "3"

replace freq_internet_19 = 4 if interntreg_19 == "4"

replace freq_internet_19 = 5 if interntreg_19 == "5"

replace freq_internet_19 = . if interntreg_19 == ""

tabulate freq_internet_19

regress AARClosses_2019 freq_internet_19, beta

regress AARCgains_2019 freq_internet_19, beta

* 2020 

generate freq_internet_20 = 0 if interntreg_20 == "0"

replace freq_internet_20 = 1 if interntreg_20 == "1"

replace freq_internet_20 = 2 if interntreg_20 == "2"

replace freq_internet_20 = 3 if interntreg_20 == "3"

replace freq_internet_20 = 4 if interntreg_20 == "4"

replace freq_internet_20 = 5 if interntreg_20 == "5"

replace freq_internet_20 = . if interntreg_20 == ""

tabulate freq_internet_20

*  How often do you use…?  social media (Facebook, Twitter, Instagram, Whatsapp, etc.)
 
codebook socialreg_19

generate freq_socmedia_19 = 0 if socialreg_19 == "0"

replace freq_socmedia_19 = 1 if socialreg_19 == "1"

replace freq_socmedia_19 = 2 if socialreg_19 == "2"

replace freq_socmedia_19 = 3 if socialreg_19 == "3"
 
replace freq_socmedia_19 = 4 if socialreg_19 == "4" 
 
replace freq_socmedia_19 = 5 if socialreg_19 == "5"
 
replace freq_socmedia_19 = . if socialreg_19 == "" 

tabulate freq_socmedia_19


generate freq_socmedia_20 = 0 if socialreg_20 == "0"

replace freq_socmedia_20 = 1 if socialreg_20 == "1"

replace freq_socmedia_20 = 2 if socialreg_20 == "2"

replace freq_socmedia_20 = 3 if socialreg_20 == "3"
 
replace freq_socmedia_20 = 4 if socialreg_20 == "4" 
 
replace freq_socmedia_20 = 5 if socialreg_20 == "5"
 
replace freq_socmedia_20 = . if socialreg_20 == "" 

tabulate freq_socmedia_20


* frequency of use of technologies

* gains

 regress freq_tech_19  AARCgains_2019, beta
 
 sem (AARCgains_2019 -> freq_tech_19), nocapslatent standardized
  
 pcorr freq_tech_19 AARCgains_2019  Age_T1 Gender_T1 EDUCATION_T1  Employment_T1
 
 sem (AARCgains_2019 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1 -> freq_tech_19  ), nocapslatent standardized 
 
 * explore whether age moderates the associations 
 
regress freq_tech_19  c.AARCgains_2019##c.Age_T1
   
 regress freq_tech_19  c.AARCgains_2019##c.Age_T1  Gender_T1 EDUCATION_T1 Employment_T1
     
  
* losses 
 
 regress freq_tech_19 AARClosses_2019 , beta
 
 sem (AARClosses_2019 -> freq_tech_19), nocapslatent standardized
 
 pcorr freq_tech_19 AARClosses_2019  Age_T1 Gender_T1 EDUCATION_T1  Employment_T1
 
  sem (AARClosses_2019 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1 -> freq_tech_19 ), nocapslatent standardized 
  
 * explore whether age moderates the associations 
 
regress freq_tech_19  c.AARClosses_2019##c.Age_T1
   
regress freq_tech_19  c.AARClosses_2019##c.Age_T1  Gender_T1 EDUCATION_T1 Employment_T1
 
 * try to inlcude both gains and losses in the same regression
 
 regress freq_tech_19 AARCgains_2019 AARClosses_2019 , beta
 
 sem (AARCgains_2019 AARClosses_2019 -> freq_tech_19), nocapslatent standardized
 
 pcorr freq_tech_19 AARCgains_2019 AARClosses_2019  Age_T1 Gender_T1 EDUCATION_T1  Employment_T1
 
  sem (AARCgains_2019 AARClosses_2019 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1 -> freq_tech_19 ), nocapslatent standardized  
  
   
 * ATOA 
 
 regress freq_tech_19  ATOA_F_19  , beta
 
 sem ( ATOA_F_19  -> freq_tech_19), nocapslatent standardized
 
 pcorr freq_tech_19  ATOA_F_19   Age_T1 Gender_T1 EDUCATION_T1  Employment_T1
 
  sem ( ATOA_F_19  Age_T1 Gender_T1 EDUCATION_T1 Employment_T1 -> freq_tech_19 ), nocapslatent standardized 
  
   * explore whether age moderates the associations 
 
regress freq_tech_19  c.ATOA_F_19##c.Age_T1
 
regress freq_tech_19  c.ATOA_F_19##c.Age_T1  Gender_T1 EDUCATION_T1 Employment_T1   

 
* interaction
 
 regress freq_tech_19 c.AARCgains_2019##c.AARClosses_2019 
 
 
 * frequency of use of the internet 
 
 * losses 
 
 regress freq_internet_19  AARClosses_2019, beta
 
 sem (AARClosses_2019 -> freq_internet_19), nocapslatent standardized
  
 pcorr freq_internet_19 AARClosses_2019  Age_T1 Gender_T1 EDUCATION_T1  Employment_T1
 
   sem (AARClosses_2019 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1 -> freq_internet_19 ), nocapslatent standardized 
 
 regress freq_internet_19  c.AARClosses_2019##c.Age_T1  
 
  regress freq_internet_19  c.AARClosses_2019##c.Age_T1 Gender_T1 EDUCATION_T1
  
  
 * gains
 
 regress freq_internet_19 AARCgains_2019 , beta
 
  sem (AARCgains_2019 -> freq_internet_19), nocapslatent standardized
  
 pcorr freq_internet_19 AARCgains_2019  Age_T1 Gender_T1 EDUCATION_T1 Employment_T1
 
  sem (AARCgains_2019 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1 -> freq_internet_19 ), nocapslatent standardized 
  
  regress freq_internet_19  c.AARCgains_2019##c.Age_T1
  
  regress freq_internet_19  c.AARCgains_2019##c.Age_T1 Gender_T1 EDUCATION_T1
  
  
* gains and losses as predictors in the same regression 
 
 regress freq_internet_19 AARCgains_2019 AARClosses_2019, beta
 
  sem (AARCgains_2019 AARClosses_2019 -> freq_internet_19), nocapslatent standardized
  
 pcorr freq_internet_19 AARCgains_2019 AARClosses_2019  Age_T1 Gender_T1 EDUCATION_T1  
   
  sem (AARCgains_2019 AARClosses_2019 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1 -> freq_internet_19 ), nocapslatent standardized 
   
  * ATOA
 
 regress freq_internet_19 ATOA_F_19 , beta
 
  sem (ATOA_F_19 -> freq_internet_19), nocapslatent standardized
  
 pcorr freq_internet_19 ATOA_F_19  Age_T1 Gender_T1 EDUCATION_T1  Employment_T1

  sem (ATOA_F_19 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1 -> freq_internet_19 ), nocapslatent standardized 
   
 regress freq_internet_19  c.ATOA_F_19##c.Age_T1
    
 regress freq_internet_19  c.ATOA_F_19##c.Age_T1 Gender_T1 EDUCATION_T1 Employment_T1 
 
 * interaction 
 
 regress freq_internet_19 c.AARCgains_2019##c.AARClosses_2019 
 
 regress freq_internet_19 c.AARCgains_2019##c.AARClosses_2019 Age_T1 Gender_T1 EDUCATION_T1
 

 * freuency of use social media 
 
 
* a categorical variable (midlife = 50-64 years, early old age = 65-74 years, and advanced old age = 75+ years)   
 
 generate agegroups = 1 if Age_T1 < 65  
  
 replace agegroups = 2 if Age_T1 == 65 | Age_T1 < 75 & Age_T1 > 65
 
 replace agegroups = 3 if Age_T1 == 75 | Age_T1 > 75
 
 * Cronbach's alpha for ATOA 
 
 
 * losses
 
 oprobit freq_socmedia_19  AARClosses_2019
 
 oprobit freq_socmedia_19  c.AARClosses_2019 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1
 
 oprobit freq_socmedia_19  c.AARClosses_2019##c.Age_T1
      
 oprobit freq_socmedia_19  c.AARClosses_2019##c.Age_T1 Gender_T1 EDUCATION_T1 Employment_T1
 
  oprobit freq_socmedia_19  c.AARClosses_2019##i.agegroups
      
 oprobit freq_socmedia_19  c.AARClosses_2019##i.agegroups Gender_T1 EDUCATION_T1 Employment_T1
 
  
 * gains 
 
 oprobit freq_socmedia_19  AARCgains_2019
 
 oprobit freq_socmedia_19  c.AARCgains_2019 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1
 
 oprobit freq_socmedia_19  c.AARCgains_2019##c.Age_T1
      
 oprobit freq_socmedia_19  c.AARCgains_2019##c.Age_T1 Gender_T1 EDUCATION_T1 Employment_T1
 
 oprobit freq_socmedia_19  c.AARCgains_2019##i.agegroups
      
 oprobit freq_socmedia_19  c.AARCgains_2019##i.agegroups Gender_T1 EDUCATION_T1 Employment_T1
 
   
 * gains and losses as predictors in the same regression 
 
 regress freq_socmedia_19 AARCgains_2019 AARClosses_2019, beta
 
 sem (AARCgains_2019 AARClosses_2019 -> freq_socmedia_19), nocapslatent standardized
  
 pcorr freq_socmedia_19 AARCgains_2019 AARClosses_2019 Age_T1 Gender_T1 EDUCATION_T1  
   
 sem (AARCgains_2019 AARClosses_2019 Age_T1 Gender_T1 EDUCATION_T1 -> freq_socmedia_19 ), nocapslatent standardized
 
  sem (AARCgains_2019 AARClosses_2019 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1 -> freq_socmedia_19 ), nocapslatent standardized  
 

* ATOA 

 oprobit freq_socmedia_19  ATOA_F_19
 
 oprobit freq_socmedia_19  c.ATOA_F_19 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1
 
 oprobit freq_socmedia_19  c.ATOA_F_19##c.Age_T1
      
 oprobit freq_socmedia_19  c.ATOA_F_19##c.Age_T1 Gender_T1 EDUCATION_T1 Employment_T1
 
 oprobit freq_socmedia_19  c.ATOA_F_19##i.agegroups
      
 oprobit freq_socmedia_19  c.ATOA_F_19##i.agegroups Gender_T1 EDUCATION_T1 Employment_T1
 
 
* interaction 
 
regress freq_socmedia_19 c.AARCgains_2019##c.AARClosses_2019 
 
regress freq_socmedia_19 c.AARCgains_2019##c.AARClosses_2019 

* 

regress freq_socmedia_20   AARClosses_2019 freq_socmedia_19, beta
 
tabulate comp_long_19 if AARClosses_2020 !=. &  freq_socmedia_20 != .

tabulate comp_long_20 if AARClosses_2020 !=. &  freq_socmedia_20 != .

* try to explore ATOA as predictors of use of computer, technologies, internet, and social media 

gen aarcloss_change = (AARClosses_2019 - AARClosses_2020) 

gen aarcgains_change = (AARCgains_2019 - AARCgains_2020) 

gen atoa_change = (ATOA_F_19 - ATOA_F_20) 

gen compfreq_change = (comp_freq_19 - comp_freq_20) 

gen techfreq_change = (freq_tech_19 - freq_tech_20) 

gen interfreq_change = (freq_internet_19 - freq_internet_20) 

gen socialfreq_change = (freq_socmedia_19 - freq_socmedia_20) 

codebook techfreq_change interfreq_change socialfreq_change 


* longitudinal analyses with change scores

 sem (AARCgains_2019  -> compfreq_change ), nocapslatent standardized
  
 sem (AARCgains_2019  -> techfreq_change ), nocapslatent standardized
  
  sem (AARCgains_2019  -> interfreq_change ), nocapslatent standardized
  
  sem (AARCgains_2019  -> socialfreq_change ), nocapslatent standardized
  
  
 sem (AARCgains_2019 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1 -> compfreq_change ), nocapslatent standardized
  
 sem (AARCgains_2019 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1 -> techfreq_change ), nocapslatent standardized
  
  sem (AARCgains_2019 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1 -> interfreq_change ), nocapslatent standardized
  
  sem (AARCgains_2019 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1 -> socialfreq_change ), nocapslatent standardized
   
 sem (AARClosses_2019  -> compfreq_change ), nocapslatent standardized
  
 sem (AARClosses_2019 -> techfreq_change ), nocapslatent standardized
  
  sem (AARClosses_2019  -> interfreq_change ), nocapslatent standardized
  
  sem (AARClosses_2019 -> socialfreq_change ), nocapslatent standardized
   
   
  sem (AARClosses_2019 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1 -> compfreq_change ), nocapslatent standardized
  
 sem (AARClosses_2019 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1 -> techfreq_change ), nocapslatent standardized
  
  sem (AARClosses_2019 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1 -> interfreq_change ), nocapslatent standardized
  
  sem (AARClosses_2019 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1 -> socialfreq_change ), nocapslatent standardized
    
    
 sem (ATOA_F_19  -> compfreq_change ), nocapslatent standardized
  
 sem (ATOA_F_19 -> techfreq_change ), nocapslatent standardized
  
  sem (ATOA_F_19  -> interfreq_change ), nocapslatent standardized
  
  sem (ATOA_F_19 -> socialfreq_change ), nocapslatent standardized
    

 sem (ATOA_F_19 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1 -> compfreq_change ), nocapslatent standardized
  
 sem (ATOA_F_19 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1 -> techfreq_change ), nocapslatent standardized
  
  sem (ATOA_F_19 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1  -> interfreq_change ), nocapslatent standardized
  
  sem (ATOA_F_19 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1 -> socialfreq_change ), nocapslatent standardized
    

* try bidirectional associations for frequency of use of the technologies

* unadjusted for ATOA

  sem (ATOA_F_20 <- ATOA_F_19 freq_tech_19) ///
(freq_tech_20<- freq_tech_19 ATOA_F_19), ///
method (mlmv) standardized nocapslatent ///
cov(e.ATOA_F_20*e.freq_tech_20)

estat eqgof

* test for significant difference between standardized path coefficients 

sem, coeflegend

estat stdize: test _b[ATOA_F_20: ATOA_F_19] = _b[freq_tech_20: freq_tech_19] 

estat stdize: test  _b[ATOA_F_20: freq_tech_19] = _b[freq_tech_20: ATOA_F_19]

* adjusted for ATOA

  sem (ATOA_F_20 <- ATOA_F_19 freq_tech_19 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1) ///
(freq_tech_20<- freq_tech_19 ATOA_F_19 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1), ///
method (mlmv) standardized nocapslatent ///
cov(e.ATOA_F_20*e.freq_tech_20)

estat eqgof

* test for significant difference between standardized path coefficients 

sem, coeflegend

estat stdize: test _b[ATOA_F_20: ATOA_F_19] = _b[freq_tech_20: freq_tech_19] 

estat stdize: test  _b[ATOA_F_20: freq_tech_19] = _b[freq_tech_20: ATOA_F_19]

* unadjusted for AARC gains

  sem (AARCgains_2020 <- AARCgains_2019 freq_tech_19) ///
(freq_tech_20<- freq_tech_19 AARCgains_2019), ///
method (mlmv) standardized nocapslatent ///
cov(e.AARCgains_2020*e.freq_tech_20)

estat eqgof

* adjusted for AARC gains

  sem (AARCgains_2020 <- AARCgains_2019 freq_tech_19 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1) ///
(freq_tech_20<- freq_tech_19 AARCgains_2019 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1), ///
method (mlmv) standardized nocapslatent ///
cov(e.AARCgains_2020*e.freq_tech_20)

estat eqgof


* test for significant difference between standardized path coefficients 

sem, coeflegend

estat stdize: test _b[AARCgains_2020: AARCgains_2019] = _b[freq_tech_20: freq_tech_19] 

estat stdize: test  _b[AARCgains_2020: freq_tech_19] = _b[freq_tech_20: AARCgains_2019]


* unadjusted for AARC losses

  sem (AARClosses_2020 <- AARClosses_2019 freq_tech_19) ///
(freq_tech_20<- freq_tech_19 AARClosses_2019), ///
method (mlmv) standardized nocapslatent ///
cov(e.AARClosses_2020*e.freq_tech_20)

estat eqgof

* test for significant difference between standardized path coefficients 

sem, coeflegend

estat stdize: test _b[AARClosses_2020: AARClosses_2019] = _b[freq_tech_20: freq_tech_19] 

estat stdize: test  _b[AARClosses_2020: freq_tech_19] = _b[freq_tech_20: AARClosses_2019]

* adjusted for AARC losses

  sem (AARClosses_2020 <- AARClosses_2019 freq_tech_19 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1) ///
(freq_tech_20<- freq_tech_19 AARClosses_2019 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1), ///
method (mlmv) standardized nocapslatent ///
cov(e.AARClosses_2020*e.freq_tech_20)

estat eqgof

* test for significant difference between standardized path coefficients 

sem, coeflegend

estat stdize: test _b[AARClosses_2020: AARClosses_2019] = _b[freq_tech_20: freq_tech_19] 

estat stdize: test  _b[AARClosses_2020: freq_tech_19] = _b[freq_tech_20: AARClosses_2019]


* try bidirectional associations for frequency of use of the internet

* unadjusted for ATOA

  sem (ATOA_F_20 <- ATOA_F_19 freq_internet_19) ///
(freq_internet_20<- freq_internet_19 ATOA_F_19), ///
method (mlmv) standardized nocapslatent ///
cov(e.ATOA_F_20*e.freq_internet_20)

estat eqgof

* test for significant difference between standardized path coefficients 

sem, coeflegend

estat stdize: test _b[ATOA_F_20: ATOA_F_19] = _b[freq_internet_20: freq_internet_19] 

estat stdize: test  _b[ATOA_F_20: freq_internet_19] = _b[freq_internet_20: ATOA_F_19]

* adjusted for ATOA

  sem (ATOA_F_20 <- ATOA_F_19 freq_internet_19 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1) ///
(freq_internet_20<- freq_internet_19 ATOA_F_19 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1), ///
method (mlmv) standardized nocapslatent ///
cov(e.ATOA_F_20*e.freq_internet_20)

estat eqgof

* test for significant difference between standardized path coefficients 

sem, coeflegend

estat stdize: test _b[ATOA_F_20: ATOA_F_19] = _b[freq_internet_20: freq_internet_19] 

estat stdize: test  _b[ATOA_F_20: freq_internet_19] = _b[freq_internet_20: ATOA_F_19]


* unadjusted for AARC gains

  sem (AARCgains_2020 <- AARCgains_2019 freq_internet_19) ///
(freq_internet_20<- freq_internet_19 AARCgains_2019), ///
method (mlmv) standardized nocapslatent ///
cov(e.AARCgains_2020*e.freq_internet_20)

estat eqgof

* test for significant difference between standardized path coefficients 

sem, coeflegend

estat stdize: test _b[AARCgains_2020: AARCgains_2019] = _b[freq_internet_20: freq_internet_19] 

estat stdize: test  _b[AARCgains_2020: freq_internet_19] = _b[freq_internet_20: AARCgains_2019]

* adjusted for AARC gains

  sem (AARCgains_2020 <- AARCgains_2019 freq_internet_19 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1) ///
(freq_internet_20<- freq_internet_19 AARCgains_2019 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1), ///
method (mlmv) standardized nocapslatent ///
cov(e.AARCgains_2020*e.freq_internet_20)

estat eqgof

* test for significant difference between standardized path coefficients 

sem, coeflegend

estat stdize: test _b[AARCgains_2020: AARCgains_2019] = _b[freq_internet_20: freq_internet_19] 

estat stdize: test  _b[AARCgains_2020: freq_internet_19] = _b[freq_internet_20: AARCgains_2019]


* unadjusted for AARC losses

  sem (AARClosses_2020 <- AARClosses_2019 freq_internet_19) ///
(freq_internet_20<- freq_internet_19 AARClosses_2019), ///
method (mlmv) standardized nocapslatent ///
cov(e.AARClosses_2020*e.freq_internet_20)

estat eqgof

* test for significant difference between standardized path coefficients 

sem, coeflegend

estat stdize: test _b[AARClosses_2020: AARClosses_2019] = _b[freq_internet_20: freq_internet_19] 

estat stdize: test  _b[AARClosses_2020: freq_internet_19] = _b[freq_internet_20: AARClosses_2019]

* adjusted for AARC losses

  sem (AARClosses_2020 <- AARClosses_2019 freq_internet_19 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1) ///
(freq_internet_20<- freq_internet_19 AARClosses_2019 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1), ///
method (mlmv) standardized nocapslatent ///
cov(e.AARClosses_2020*e.freq_internet_20)

estat eqgof

* test for significant difference between standardized path coefficients 

sem, coeflegend

estat stdize: test _b[AARClosses_2020: AARClosses_2019] = _b[freq_internet_20: freq_internet_19] 

estat stdize: test  _b[AARClosses_2020: freq_internet_19] = _b[freq_internet_20: AARClosses_2019]


* L OUTCOME VA MESSO COME DUMMY VARIALE E IL PREDICTOR O COME DUMMY O CONTINUOUS

* need to dummy code social media in 2019

generate neversm19 = 1 if freq_socmedia_19 == 0 

replace neversm19 = 0 if freq_socmedia_19 == 1 | freq_socmedia_19 == 2 | freq_socmedia_19 == 3 | freq_socmedia_19 == 4 | freq_socmedia_19 == 5


generate occassm19 = 1 if freq_socmedia_19 == 1 

replace occassm19 = 0 if freq_socmedia_19 == 0 | freq_socmedia_19 == 2 | freq_socmedia_19 == 3 | freq_socmedia_19 == 4 | freq_socmedia_19 == 5


generate oncemonsm19 = 1 if freq_socmedia_19 == 2

replace oncemonsm19 = 0 if freq_socmedia_19 == 0 | freq_socmedia_19 == 1 | freq_socmedia_19 == 3 | freq_socmedia_19 == 4 | freq_socmedia_19 == 5


generate onceweeksm19 = 1 if freq_socmedia_19 == 3

replace onceweeksm19 = 0 if freq_socmedia_19 == 0 | freq_socmedia_19 == 1 | freq_socmedia_19 == 2 | freq_socmedia_19 == 4 | freq_socmedia_19 == 5


generate oncedaysm19 = 1 if freq_socmedia_19 == 4

replace oncedaysm19 = 0 if freq_socmedia_19 == 0 | freq_socmedia_19 == 1 | freq_socmedia_19 == 2 | freq_socmedia_19 == 3 | freq_socmedia_19 == 5


generate multipledaysm19 = 1 if freq_socmedia_19 == 5

replace multipledaysm19 = 0 if freq_socmedia_19 == 0 | freq_socmedia_19 == 1 | freq_socmedia_19 == 2 | freq_socmedia_19 == 3 | freq_socmedia_19 == 4


tabulate neversm19

tabulate occassm19

tabulate oncemonsm19 

tabulate onceweeksm19

tabulate oncedaysm19

tabulate  multipledaysm19

* need to dummy code social media in 2020 

generate neversm20 = 1 if freq_socmedia_20 == 0 

replace neversm20 = 0 if freq_socmedia_20 == 1 | freq_socmedia_20 == 2 | freq_socmedia_20 == 3 | freq_socmedia_20 == 4 | freq_socmedia_20 == 5


generate occassm20 = 1 if freq_socmedia_20 == 1 

replace occassm20 = 0 if freq_socmedia_20 == 0 | freq_socmedia_20 == 2 | freq_socmedia_20 == 3 | freq_socmedia_20 == 4 | freq_socmedia_20 == 5


generate oncemonsm20 = 1 if freq_socmedia_20 == 2

replace oncemonsm20 = 0 if freq_socmedia_20 == 0 | freq_socmedia_20 == 1 | freq_socmedia_20 == 3 | freq_socmedia_20 == 4 | freq_socmedia_20 == 5


generate onceweeksm20 = 1 if freq_socmedia_20 == 3

replace onceweeksm20 = 0 if freq_socmedia_20 == 0 | freq_socmedia_20 == 1 | freq_socmedia_20 == 2 | freq_socmedia_20 == 4 | freq_socmedia_20 == 5


generate oncedaysm20 = 1 if freq_socmedia_20 == 4

replace oncedaysm20 = 0 if freq_socmedia_20 == 0 | freq_socmedia_20 == 1 | freq_socmedia_20 == 2 | freq_socmedia_20 == 3 | freq_socmedia_20 == 5


generate multipledaysm20 = 1 if freq_socmedia_20 == 5

replace multipledaysm20 = 0 if freq_socmedia_20 == 0 | freq_socmedia_20 == 1 | freq_socmedia_20 == 2 | freq_socmedia_20 == 3 | freq_socmedia_20 == 4


tabulate neversm20

tabulate occassm20

tabulate oncemonsm20

tabulate onceweeksm20

tabulate oncedaysm20

tabulate  multipledaysm20


* ORDERED LAGGED REGRESSIONS 

gsem (occassm20 oncemonsm20 onceweeksm20 oncedaysm20  multipledaysm20 <- ATOA_F_19 occassm19 oncemonsm19 onceweeksm19 oncedaysm19  multipledaysm19), oprobit

gsem (occassm20 oncemonsm20 onceweeksm20 oncedaysm20  multipledaysm20 <- ATOA_F_19 freq_socmedia_19), oprobit


 oprobit freq_socmedia_20  ATOA_F_19 i.freq_socmedia_19
 
 oprobit freq_socmedia_20   AARCgains_2019 i.freq_socmedia_19

 oprobit freq_socmedia_20   AARClosses_2019 i.freq_socmedia_19
 
 oprobit freq_socmedia_20  ATOA_F_19 i.freq_socmedia_19 Age_T1 Gender_T1 i.EDUCATION_T1 Employment_T1
 
 oprobit freq_socmedia_20   AARCgains_2019 i.freq_socmedia_19 Age_T1 Gender_T1 i.EDUCATION_T1 Employment_T1
 
 oprobit freq_socmedia_20   AARClosses_2019 i.freq_socmedia_19 Age_T1 Gender_T1 i.EDUCATION_T1 Employment_T1
 
 regress ATOA_F_20 i.freq_socmedia_19 ATOA_F_19 
 
 regress AARCgains_2020 i.freq_socmedia_19 AARCgains_2019
 
 regress AARClosses_2020 i.freq_socmedia_19 AARClosses_2019   
 
 regress ATOA_F_20 i.freq_socmedia_19 ATOA_F_19 Age_T1 Gender_T1 i.EDUCATION_T1 Employment_T1
 
 regress AARCgains_2020 i.freq_socmedia_19 AARCgains_2019 Age_T1 Gender_T1 i.EDUCATION_T1 Employment_T1
 
 regress AARClosses_2020 i.freq_socmedia_19 AARClosses_2019  Age_T1 Gender_T1 i.EDUCATION_T1 Employment_T1 
 
 
 
* bidirectional associations for frequency of engagement with social media 

* unadjusted for ATOA

  sem (ATOA_F_20 <- ATOA_F_19 freq_socmedia_19) ///
(freq_socmedia_20<- freq_socmedia_19 ATOA_F_19), ///
method (mlmv) standardized nocapslatent ///
cov(e.ATOA_F_20*e.freq_socmedia_20)

estat eqgof

* test for significant difference between standardized path coefficients 

sem, coeflegend

estat stdize: test _b[ATOA_F_20: ATOA_F_19] = _b[freq_socmedia_20: freq_socmedia_19] 

estat stdize: test  _b[ATOA_F_20: freq_socmedia_19] = _b[freq_socmedia_20: ATOA_F_19]

* adjusted for ATOA

  sem (ATOA_F_20 <- ATOA_F_19 freq_socmedia_19 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1) ///
(freq_socmedia_20<- freq_socmedia_19 ATOA_F_19 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1), ///
method (mlmv) standardized nocapslatent ///
cov(e.ATOA_F_20*e.freq_socmedia_20)

estat eqgof

* test for significant difference between standardized path coefficients 

sem, coeflegend

estat stdize: test _b[ATOA_F_20: ATOA_F_19] = _b[freq_socmedia_20: freq_socmedia_19] 

estat stdize: test  _b[ATOA_F_20: freq_socmedia_19] = _b[freq_socmedia_20: ATOA_F_19]



* unadjusted for AARC gains

  sem (AARCgains_2020 <- AARCgains_2019 freq_socmedia_19) ///
(freq_socmedia_20<- freq_socmedia_19 AARCgains_2019), ///
method (mlmv) standardized nocapslatent ///
cov(e.AARCgains_2020*e.freq_socmedia_20)

estat eqgof

* test for significant difference between standardized path coefficients 

sem, coeflegend

estat stdize: test _b[AARCgains_2020: AARCgains_2019] = _b[freq_socmedia_20: freq_socmedia_19] 

estat stdize: test  _b[AARCgains_2020: freq_socmedia_19] = _b[freq_socmedia_20: AARCgains_2019]

* adjusted for AARC gains

  sem (AARCgains_2020 <- AARCgains_2019 freq_socmedia_19 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1) ///
(freq_socmedia_20<- freq_socmedia_19 AARCgains_2019 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1), ///
method (mlmv) standardized nocapslatent ///
cov(e.AARCgains_2020*e.freq_socmedia_20)

estat eqgof

* test for significant difference between standardized path coefficients 

sem, coeflegend

estat stdize: test _b[AARCgains_2020: AARCgains_2019] = _b[freq_socmedia_20: freq_socmedia_19] 

estat stdize: test  _b[AARCgains_2020: freq_socmedia_19] = _b[freq_socmedia_20: AARCgains_2019]



* unadjusted for AARC losses

  sem (AARClosses_2020 <- AARClosses_2019 freq_socmedia_19) ///
(freq_socmedia_20<- freq_socmedia_19 AARClosses_2019), ///
method (mlmv) standardized nocapslatent ///
cov(e.AARClosses_2020*e.freq_socmedia_20)

estat eqgof

* test for significant difference between standardized path coefficients 

sem, coeflegend

estat stdize: test _b[AARClosses_2020: AARClosses_2019] = _b[freq_socmedia_20: freq_socmedia_19] 

estat stdize: test  _b[AARClosses_2020: freq_socmedia_19] = _b[freq_socmedia_20: AARClosses_2019]


* adjusted for AARC losses

  sem (AARClosses_2020 <- AARClosses_2019 freq_socmedia_19 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1) ///
(freq_socmedia_20<- freq_socmedia_19 AARClosses_2019 Age_T1 Gender_T1 EDUCATION_T1 Employment_T1), ///
method (mlmv) standardized nocapslatent ///
cov(e.AARClosses_2020*e.freq_socmedia_20)

estat eqgof

* test for significant difference between standardized path coefficients 

sem, coeflegend

estat stdize: test _b[AARClosses_2020: AARClosses_2019] = _b[freq_socmedia_20: freq_socmedia_19] 

estat stdize: test  _b[AARClosses_2020: freq_socmedia_19] = _b[freq_socmedia_20: AARClosses_2019]


generate longsample = 1 if  AARClosses_2020 !=. & freq_socmedia_20 != .

replace longsample = 0 if AARClosses_2020 ==. | freq_socmedia_20 == .

drop _merge

summarize Age_T1 AARCgains_2019 AARClosses_2019 ATOA_F_19 if longsample == 0

tabulate Gender_T1 if longsample == 0

tabulate EDUCATION_T1 if longsample == 0

tabulate Employment_T1 if longsample == 0

tabulate socialreg_19 if longsample == 0

tabulate interntreg_19 if longsample == 0

tabulate techreg_19 if longsample == 0


tabulate Employment_T1 if longsample == 1

summarize  ATOA_F_19 if longsample == 1

summarize  ATOA_F_20 if longsample == 1

** p values for differences in the two samples

summarize Age_T1 AARCgains_2019 AARClosses_2019 ATOA_F_19 if longsample == 0

tabulate Gender_T1 if longsample == 0

tabulate EDUCATION_T1 if longsample == 0

tabulate Employment_T1 if longsample == 0

tabulate socialreg_19 if longsample == 0

tabulate interntreg_19 if longsample == 0

tabulate techreg_19 if longsample == 0



oneway   Age_T1  longsample , bonferroni tabulate 

anova  Age_T1  longsample
 
estat esize  


oneway   AARCgains_2019  longsample , bonferroni tabulate 

anova AARCgains_2019  longsample
 
estat esize 


oneway   AARClosses_2019  longsample , bonferroni tabulate 

anova  AARClosses_2019  longsample
 
estat esize 


oneway   ATOA_F_19  longsample , bonferroni tabulate 

anova  ATOA_F_19  longsample
 
estat esize 

tab  Gender_T1  longsample, chi2 

tab  EDUCATION_T1  longsample, chi2 

tab  Employment_T1  longsample, chi2 

tab  socialreg_19  longsample, chi2 

tab  interntreg_19  longsample, chi2 

tab  techreg_19 longsample, chi2 




 
 
 
